
Type TContact

	Field Position:Vector2 = Vector2.Zero() 
	Field Normal:Vector2 = Vector2.Zero() 
	Field Seperation:Float
	
	Field _contactId:TContactId = New TContactId
	Field _normalImpulse:Float
	Field _tangentImpulse:Float
	Field _massNormal:Float
	Field _massTangent:Float
	Field _normalVelocityBias:Float
	Field _normalImpulseBias:Float
	Field _r1:Vector2 = Vector2.Zero() 
	Field _r2:Vector2 = Vector2.Zero() 
	Field _bounceVelocity:Float
	
	
	Function Create:TContact(position:Vector2, normal:Vector2, seperation:Float, contactId:TContactId) 
		Local c:TContact = New TContact
		contactId.CopyTo(c._contactId)
		c.Position.X = position.X
		c.Position.Y = position.Y
		c.Normal.X = normal.X
		c.Normal.Y = normal.Y
		c.Seperation = seperation
		c._normalImpulse = 0
		c._tangentImpulse = 0
		c._massNormal = 0
		c._massTangent = 0
		c._normalVelocityBias = 0
		c._normalImpulseBias = 0
		c._bounceVelocity = 0
		Return c
	End Function
	
	rem
	bbdoc: used in conjunction with pooling
	end rem
	Method Init(position:Vector2, normal:Vector2, seperation:Float, contactId:TContactId) 
		contactId.CopyTo(_contactId)
		Self.Position.X = position.X
		Self.Position.Y = position.Y
		Self.Normal.X = normal.X
		Self.Normal.Y = normal.Y
		Self.Seperation = seperation
		_normalImpulse = 0
		_tangentImpulse = 0
		_massNormal = 0
		_massTangent = 0
		_normalVelocityBias = 0
		_normalImpulseBias = 0
		_bounceVelocity = 0
	End Method
	
	Method SetMassNormal(massNormal:Float) 
		_massNormal = massNormal
	End Method
	
	Method SetMassTangent(massTangent:Float) 
		_massTangent = massTangent
	End Method
	
	Method SetBias(bias:Float) 
		_normalVelocityBias = bias
	End Method
	
	Method SetNormalImpulse(normalImpulse:Float) 
		_normalImpulse = normalImpulse
	End Method
	
	Method SetTangentImpulse(tangentImpulse:Float) 
		_tangentImpulse = tangentImpulse
	End Method
	
	Method Equals:Int(o:Object) 
		If TContact(o) Then
			Local other:TContact = TContact(o) 
			Return other._contactId.Equals(_contactId) 
		End If
		Throw "The object being compared must be of type 'TContact'"
		Return False
	End Method
	
	rem
	bbdoc: note: do not define a compare method for contacts. separation is NOT unique.
	This broke the removeRange() method since some separations equaled each other.
	end rem
'	Method Compare:Int(o:Object) 
'		Local c:TContact = TContact(o) 
'		If Self.Seperation < c.Seperation Then
'			Return - 1
'		Else If Self.Seperation = c.Seperation Then
'			Return 0
'		Else
'			Return 1
'		End If
'	End Method
End Type
